from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth import login, logout, authenticate
from django.contrib.auth.decorators import login_required
from django.contrib import messages
from django.db.models import Q
from django.utils import timezone
from django.http import JsonResponse, HttpResponse
from decimal import Decimal, InvalidOperation
import os
import pandas as pd
import json
from datetime import datetime, timedelta  # این خط را اضافه کنید
from django.core.files.storage import FileSystemStorage
from django.http import JsonResponse, HttpResponse
from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth import login, logout, authenticate
from django.contrib.auth.decorators import login_required
from django.contrib import messages
from django.db.models import Q
from django.utils import timezone
from decimal import Decimal, InvalidOperation
import json
import os
import pandas as pd
import json
from django.core.files.storage import FileSystemStorage
from django.http import JsonResponse
from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth import login, logout, authenticate
from django.contrib.auth.decorators import login_required
from django.contrib import messages
from django.db.models import Q
from django.utils import timezone
from django.http import JsonResponse, HttpResponse
from decimal import Decimal, InvalidOperation
import json
# importهای مشخص به جای import *
from .models import (
    User, Car, CarType, Buyer, Intermediary, Parking, 
    CarItem, Inspection, InspectionMissingItem, 
    FinanceReview, ManagerApproval, SystemLog
)
from .forms import (
    UserRegistrationForm, LoginForm, ChassisCheckForm, 
    CarInfoForm, IntermediaryForm, ParkingForm, 
    InspectionForm, CarItemForm, FinanceReviewForm, ManagerApprovalForm,
    ExcelUploadForm  # این خط را اضافه کنید
)
from .utils import add_log, is_inspector, is_finance, is_manager, is_admin

# بقیه importها...

# importهای مشخص به جای import *
from .models import (
    User, Car, CarType, Buyer, Intermediary, Parking, 
    CarItem, Inspection, InspectionMissingItem, 
    FinanceReview, ManagerApproval, SystemLog
)
from .forms import (
    UserRegistrationForm, LoginForm, ChassisCheckForm, 
    CarInfoForm, IntermediaryForm, ParkingForm, 
    InspectionForm, CarItemForm, FinanceReviewForm, ManagerApprovalForm
)
import pandas as pd
import json
from django.core.files.storage import FileSystemStorage
from django.http import JsonResponse
from .utils import add_log, is_inspector, is_finance, is_manager, is_admin


# مرحله 1: ثبت اطلاعات خودرو (کاربر عادی)
@login_required
def car_info(request):
    if request.user.user_type != 'customer':
        messages.error(request, 'شما اجازه ثبت خودرو ندارید.')
        return redirect('dashboard')

    if request.method == 'POST':
        form = CarInfoForm(request.POST)
        if form.is_valid():
            car = Car.objects.create(
                user=request.user,
                owner_name=form.cleaned_data['owner_name'],
                plate_number=form.cleaned_data['plate_number'],
                vin=form.cleaned_data['vin'],
                system=form.cleaned_data['system'],
                car_type=form.cleaned_data.get('car_type', CarType.objects.first()),
                model=form.cleaned_data['model'],
                engine_number=form.cleaned_data['engine_number'],
                color=form.cleaned_data['color'],
                capacity=form.cleaned_data['capacity'],
                base_price=form.cleaned_data['base_price'],
                province='تهران',
                status='inspection'
            )
            add_log("ثبت اطلاعات خودرو", f"پلاک: {car.plate_number}", request.user, request)
            messages.success(request, 'خودرو ثبت شد. منتظر بازرسی باشید.')
            return redirect('cars_list')
    else:
        form = CarInfoForm()

    return render(request, 'cars/car_info.html', {'form': form})




@login_required
def finance_list(request):
    """لیست خودروهای در انتظار بررسی مالی"""
    if not is_finance(request.user):
        messages.error(request, 'شما دسترسی به این صفحه ندارید.')
        return redirect('dashboard')

    # فقط خودروهای استان کاربر مالی و با وضعیت finance
    cars = Car.objects.filter(
        status='finance',
        province=request.user.province
    ).order_by('-created_at')

    context = {
        'cars': cars,
    }
    return render(request, 'cars/finance_list.html', context)


@login_required
def inspect_car(request, car_id):
    """بازرسی خودرو - ثبت آیتم‌های مفقوده"""
    if not is_inspector(request.user):
        messages.error(request, 'دسترسی غیرمجاز! فقط بازرسان می‌توانند بازرسی انجام دهند.')
        return redirect('dashboard')
    
    car = get_object_or_404(Car, id=car_id, province=request.user.province, status='inspection')
    
    # دریافت آیتم‌های فعال
    car_items = CarItem.objects.filter(
        Q(car_type='general') | Q(car_type=car.car_type.type_name),
        is_active=True
    ).order_by('category', 'name')
    
    if request.method == 'POST':
        # دیباگ: چاپ تمام داده‌های POST
        print("=== دیباگ فرم بازرسی ===")
        for key, value in request.POST.items():
            print(f"{key}: {value}")
        
        # روش صحیح دریافت آیتم‌های انتخاب شده
        missing_items_ids = []
        for key, value in request.POST.items():
            if key.startswith('missing_item_'):
                # اگر checkbox انتخاب شده باشد، مقدار 'on' یا مقدار واقعی ارسال می‌شود
                if value and value != 'on':  # فقط اگر مقدار داشته باشد و 'on' نباشد
                    try:
                        missing_items_ids.append(int(value))
                    except ValueError:
                        print(f"مقدار غیر عددی نادیده گرفته شد: {value}")
                elif value == 'on':
                    # اگر مقدار 'on' است، از نام فیلد ID را استخراج کنیم
                    try:
                        item_id = int(key.replace('missing_item_', ''))
                        missing_items_ids.append(item_id)
                    except ValueError:
                        print(f"نام فیلد غیر عددی: {key}")
        
        print(f"آیتم‌های انتخاب شده: {missing_items_ids}")
        
        notes = request.POST.get('notes', '')
        overall_status = request.POST.get('overall_status')
        
        # ایجاد بازرسی
        inspection = Inspection.objects.create(
            car=car,
            inspector=request.user,
            notes=notes,
            status='approved' if overall_status == 'approved' else 'rejected'
        )
        
        # ثبت آیتم‌های مفقوده
        items_registered = 0
        for item_id in missing_items_ids:
            try:
                item = CarItem.objects.get(id=item_id)
                InspectionMissingItem.objects.create(
                    inspection=inspection,
                    item=item,
                    item_price=0
                )
                items_registered += 1
                print(f"✅ آیتم {item.name} (ID: {item_id}) ثبت شد")
            except CarItem.DoesNotExist:
                print(f"❌ آیتم با ID {item_id} یافت نشد")
        
        # تغییر وضعیت خودرو به مالی
        car.status = 'finance'
        car.save()
        
        add_log('ثبت بازرسی', f'بازرسی خودرو {car.plate_number} - {items_registered} آیتم مفقوده', request.user, request)
        messages.success(request, f'✅ بازرسی ثبت شد. {items_registered} آیتم مفقوده ثبت گردید.')
        return redirect('inspection_list')
    
    context = {
        'car': car,
        'car_items': car_items,
    }
    return render(request, 'cars/inspect_car.html', context)

@login_required
def finance_view(request, car_id):
    """بررسی مالی - محاسبه قیمت آیتم‌های مفقوده"""
    if not is_finance(request.user):
        messages.error(request, 'شما دسترسی به این صفحه ندارید.')
        return redirect('dashboard')

    car = get_object_or_404(Car, id=car_id, status='finance', province=request.user.province)
    
    print(f"=== دیباگ مالی برای خودرو {car.id} ===")
    print(f"پلاک: {car.plate_number}, وضعیت: {car.status}")
    
    inspection = car.inspections.last()
    
    if not inspection:
        print("❌ هیچ بازرسی یافت نشد!")
        messages.error(request, 'بازرسی برای این خودرو یافت نشد.')
        return redirect('finance_list')
    
    print(f"✅ بازرسی یافت شد: ID {inspection.id}")
    
    # دریافت آیتم‌های مفقوده
    missing_items = inspection.missing_items.all()
    print(f"تعداد آیتم‌های مفقوده: {missing_items.count()}")
    
    for i, item in enumerate(missing_items):
        print(f"  {i+1}. {item.item.name} (ID: {item.id})")
    
    if request.method == 'POST':
        try:
            car_price = Decimal(request.POST.get('car_price', 0))
            print(f"قیمت پایه دریافت شده: {car_price}")
            
            total_deduction = Decimal('0')
            for missing_item in missing_items:
                item_price = Decimal(request.POST.get(f'item_price_{missing_item.id}', 0))
                print(f"آیتم {missing_item.item.name}: قیمت کسر = {item_price}")
                missing_item.item_price = item_price
                missing_item.save()
                total_deduction += item_price
            
            final_price = car_price - total_deduction
            
            car.base_price = car_price
            car.save()
            
            FinanceReview.objects.create(
                car=car,
                finance_user=request.user,
                suggested_price=final_price,
                notes=request.POST.get('notes', '')
            )
            
            car.status = 'manager'
            car.save()
            
            add_log("بررسی مالی", f"قیمت پایه: {car_price} - کسورات: {total_deduction} - قیمت نهایی: {final_price}", request.user, request)
            messages.success(request, f'بررسی مالی ثبت شد. {missing_items.count()} آیتم مفقوده محاسبه شد.')
            return redirect('finance_list')
            
        except (ValueError, InvalidOperation) as e:
            messages.error(request, f'خطا در مقادیر عددی: {str(e)}')
            print(f"❌ خطا: {str(e)}")
    
    initial_car_price = car.base_price if car.base_price > 0 else 100000000
    
    context = {
        'car': car,
        'inspection': inspection,
        'missing_items': missing_items,
        'initial_car_price': initial_car_price,
        'initial_suggested_price': initial_car_price,
    }
    return render(request, 'cars/finance_review.html', context)


# مرحله 4: تأیید مدیر
@login_required
def manager_approval_list(request):
    """لیست خودروهای در انتظار تایید مدیر"""
    if not is_manager(request.user):
        messages.error(request, 'دسترسی غیرمجاز!')
        return redirect('dashboard')
    
    # خودروهای با وضعیت 'manager' که منتظر تایید هستند
    cars = Car.objects.filter(status='manager').select_related(
        'car_type', 'user'
    ).prefetch_related(
        'inspections', 'finance_reviews'
    ).order_by('-created_at')
    
    context = {
        'cars': cars,
    }
    return render(request, 'cars/manager_approval_list.html', context)

@login_required
def manager_approval_detail(request, car_id):
    """صفحه جزئیات برای تایید نهایی مدیر"""
    if not is_manager(request.user):
        messages.error(request, 'دسترسی غیرمجاز!')
        return redirect('dashboard')
    
    car = get_object_or_404(Car, id=car_id, status='manager')
    inspection = car.inspections.last()
    finance_review = car.finance_reviews.last()
    missing_items = inspection.missing_items.all().select_related('item') if inspection else []
    
    # محاسبه مجموع کسری‌ها
    total_deduction = sum(item.item_price for item in missing_items)
    
    if request.method == 'POST':
        approved = request.POST.get('approved') == 'true'
        notes = request.POST.get('notes', '')
        
        # استفاده از update_or_create برای جلوگیری از مشکل NULL
        approval, created = ManagerApproval.objects.update_or_create(
            car=car,
            defaults={
                'manager': request.user,
                'approved': approved,
                'notes': notes
            }
        )
        
        # تغییر وضعیت خودرو
        car.status = 'approved' if approved else 'rejected'
        car.save()
        
        add_log("تأیید مدیر", f"نتیجه: {'تایید' if approved else 'رد'} - پلاک: {car.plate_number}", request.user, request)
        messages.success(request, 'تأیید نهایی ثبت شد.')
        return redirect('manager_approval_list')
    
    context = {
        'car': car,
        'inspection': inspection,
        'finance_review': finance_review,
        'missing_items': missing_items,
        'total_deduction': total_deduction,
    }
    return render(request, 'cars/manager_approval_detail.html', context)


# لیست خودروها برای کاربر عادی
@login_required
def cars_list(request):
    cars = Car.objects.filter(user=request.user)
    return render(request, 'cars/cars_list.html', {'cars': cars})


def car_info(request):
    if 'current_chassis' not in request.session:
        return redirect('chassis_check')
    
    if request.method == 'POST':
        form = CarInfoForm(request.POST)
        if form.is_valid():
            car_data = form.cleaned_data

            # تبدیل Decimal به float ساده
            for key, value in car_data.items():
                try:
                    car_data[key] = float(value)
                except (ValueError, TypeError):
                    pass

            # ذخیره داده‌ها در session
            request.session['current_car_data'] = car_data

            # اضافه کردن نوع خودرو اگر وجود ندارد
            car_type_name = car_data['car_type']  # ✅ درست
            if car_type_name and not CarType.objects.filter(type_name=car_type_name).exists():
                CarType.objects.create(type_name=car_type_name)
            
            request.session['current_step'] = 'intermediary'

            # ✅ ریدایرکت به مرحله بعد
            return redirect('intermediary')
        else:
            # اگر فرم نامعتبر بود، فرم را دوباره نمایش بده
            return render(request, 'cars/car_info.html', {'form': form})
    
    else:
        form = CarInfoForm()
    
    return render(request, 'cars/car_info.html', {'form': form})



def login_view(request):
    if request.user.is_authenticated:
        return redirect('dashboard')
    
    if request.method == 'POST':
        form = LoginForm(request.POST)
        if form.is_valid():
            national_code = form.cleaned_data['national_code']
            shenasnameh_code = form.cleaned_data['shenasnameh_code']
            
            try:
                user = User.objects.get(
                    national_code=national_code,
                    shenasnameh_code=shenasnameh_code
                )
                login(request, user)
                add_log('ورود به سیستم', f'ورود کاربر: {user.get_full_name()}', user, request)
                messages.success(request, 'ورود موفقیت آمیز بود')
                return redirect('dashboard')
            except User.DoesNotExist:
                messages.error(request, 'کد ملی یا شماره شناسنامه اشتباه است')
    else:
        form = LoginForm()
    
    return render(request, 'cars/login.html', {'form': form})

def register_view(request):
    if request.user.is_authenticated:
        return redirect('dashboard')
    
    if request.method == 'POST':
        form = UserRegistrationForm(request.POST)
        if form.is_valid():
            user = form.save()
            login(request, user)
            add_log('ثبت نام کاربر', f'ثبت نام کاربر جدید: {user.get_full_name()}', user, request)
            messages.success(request, f'ثبت نام با موفقیت انجام شد!')
            return redirect('dashboard')
    else:
        form = UserRegistrationForm()
    
    return render(request, 'cars/register.html', {'form': form})

def logout_view(request):
    add_log('خروج از سیستم', f'خروج کاربر: {request.user.get_full_name()}', request.user, request)
    logout(request)
    return redirect('login')

@login_required
def dashboard(request):
    context = {}
    user = request.user
    
    if is_admin(user):
        context['users_count'] = User.objects.count()
        context['cars_count'] = Car.objects.count()
        context['inspections_count'] = Inspection.objects.count()
        context['items_count'] = CarItem.objects.count()
        context['recent_logs'] = SystemLog.objects.select_related('user').order_by('-created_at')[:10]
    
    elif is_inspector(user):
        # محاسبه مستقیم تعداد خودروهای در انتظار - بدون استفاده از context processor
        context['pending_count'] = Car.objects.filter(
            status='inspection', 
            province=user.province
        ).count()
        context['approved_count'] = Car.objects.filter(
            status='approved', province=user.province
        ).count()
        context['rejected_count'] = Car.objects.filter(
            status='rejected', province=user.province
        ).count()
        context['inspections_count'] = Inspection.objects.filter(
            inspector=user
        ).count()
        context['recent_cars'] = Car.objects.filter(
            province=user.province
        ).order_by('-created_at')[:5]
    
    else:
        context['cars_count'] = Car.objects.filter(user=user).count()
        context['pending_count'] = Car.objects.filter(
            user=user, status='pending'
        ).count()
        context['approved_count'] = Car.objects.filter(
            user=user, status='approved'
        ).count()
        context['rejected_count'] = Car.objects.filter(
            user=user, status='rejected'
        ).count()
        context['recent_cars'] = Car.objects.filter(
            user=user
        ).order_by('-created_at')[:5]
    
    return render(request, 'cars/dashboard.html', context)

@login_required
def start_sale(request):
    request.session['current_step'] = 'chassis_check'
    request.session.pop('current_chassis', None)
    request.session.pop('current_car_data', None)
    request.session.pop('current_buyer_data', None)
    return redirect('chassis_check')

@login_required
def chassis_check(request):
    if request.method == 'POST':
        form = ChassisCheckForm(request.POST)
        if form.is_valid():
            chassis_number = form.cleaned_data['chassis_number']
            
            if Car.objects.filter(vin=chassis_number).exists():
                messages.error(request, 'این شماره بدنه قبلاً در سیستم ثبت شده است')
            else:
                request.session['current_chassis'] = chassis_number
                request.session['current_step'] = 'car_info'
                return redirect('car_info')
    else:
        form = ChassisCheckForm()
    
    return render(request, 'cars/chassis_check.html', {'form': form})


@login_required
def intermediary_view(request):
    if 'current_car_data' not in request.session:
        return redirect('car_info')
    
    buyers = Buyer.objects.filter(province=request.user.province)
    intermediaries = Intermediary.objects.filter(province=request.user.province)
    
    if request.method == 'POST':
        form = IntermediaryForm(request.POST)
        if form.is_valid():
            request.session['current_buyer_data'] = form.cleaned_data
            request.session['current_step'] = 'parking'
            return redirect('parking')
    else:
        form = IntermediaryForm()
    
    context = {
        'form': form,
        'buyers': buyers,
        'intermediaries': intermediaries,
    }
    return render(request, 'cars/intermediary.html', context)

@login_required
def parking_view(request):
    if 'current_buyer_data' not in request.session:
        return redirect('intermediary')
    
    if request.method == 'POST':
        form = ParkingForm(request.POST)
        if form.is_valid():
            parking_data = form.cleaned_data
            
            # بررسی اینکه جای پارک رزرو نباشه
            if Parking.objects.filter(
                parking_zone=parking_data['parking_zone'],
                parking_number=parking_data['parking_number'],
                province=request.user.province,
                park_date=parking_data['park_date']
            ).exists():
                messages.error(request, '❌ این جای پارک در تاریخ انتخاب شده قبلاً رزرو شده است.')
                return redirect('parking')
            
            # گرفتن داده‌های مرحله‌های قبل
            car_data = request.session.get('current_car_data')
            buyer_data = request.session.get('current_buyer_data')
            
            # ✅ ساخت یا گرفتن CarType بر اساس نام
            car_type_name = car_data.get('car_type')
            car_type_obj, created = CarType.objects.get_or_create(type_name=car_type_name)
            
            # ✅ ساخت ماشین
            car = Car.objects.create(
                vin=request.session['current_chassis'],  # ✅ شماره بدنه
                owner_name=car_data['owner_name'],
                plate_number=car_data['plate_number'],
                system=car_data['system'],
                car_type=car_type_obj,
                model=car_data['model'],
                engine_number=car_data['engine_number'],
                color=car_data['color'],
                capacity=car_data['capacity'],
                base_price=car_data['base_price'],
                user=request.user,
                buyer_id=buyer_data['buyer_id'],
                intermediary_id=buyer_data['intermediary_id'],
                province=request.user.province,
                status='inspection'  # بره مرحله بازرسی
            )

            
            # ✅ ثبت پارکینگ
            Parking.objects.create(
                car=car,
                parking_zone=parking_data['parking_zone'],
                parking_number=parking_data['parking_number'],
                park_date=parking_data['park_date'],
                park_time=parking_data['park_time'],
                province=request.user.province
            )
            
            # ثبت در لاگ
            add_log('ثبت خودرو جدید', f'ثبت خودرو با شماره بدنه: {car.vin}', request.user, request)
            
            # پاک کردن اطلاعات موقت از سشن
            for key in ['current_chassis', 'current_car_data', 'current_buyer_data']:
                request.session.pop(key, None)
            request.session['current_step'] = 'dashboard'
            
            messages.success(request, '✅ خودرو با موفقیت ثبت و برای بازرسی ارسال شد.')
            return redirect('dashboard')
    else:
        form = ParkingForm()
    
    return render(request, 'cars/parking.html', {'form': form})


@login_required
def cars_list(request):
    user = request.user
    search_term = request.GET.get('search', '')
    
    if is_admin(user):
        cars = Car.objects.all()
    elif is_inspector(user):
        cars = Car.objects.filter(province=user.province)
    else:
        cars = Car.objects.filter(user=user)
    
    if search_term:
        cars = cars.filter(
            Q(chassis_number__icontains=search_term) |
            Q(model__icontains=search_term) |
            Q(owner_name__icontains=search_term) |
            Q(plate_number__icontains=search_term)
        )
    
    cars = cars.order_by('-created_at')
    
    context = {
        'cars': cars,
        'search_term': search_term,
    }
    return render(request, 'cars/cars_list.html', context)

@login_required
def inspection_list(request):
    """تاریخچه بازرسی‌های انجام شده توسط بازرس"""
    if not is_inspector(request.user):
        messages.error(request, 'دسترسی غیرمجاز! فقط بازرسان می‌توانند این صفحه را مشاهده کنند.')
        return redirect('dashboard')
    
    inspections = Inspection.objects.filter(
        inspector=request.user
    ).select_related('car').order_by('-created_at')
    
    context = {
        'inspections': inspections,
        'title': 'تاریخچه بازرسی‌ها'
    }
    return render(request, 'cars/inspection_list.html', context)


@login_required
def admin_dashboard(request):
    """داشبورد مدیریت - برای مدیر سیستم"""
    if not is_admin(request.user):
        messages.error(request, 'دسترسی غیرمجاز! فقط مدیر سیستم می‌تواند به این صفحه دسترسی داشته باشد.')
        return redirect('dashboard')
    
    context = {
        'users_count': User.objects.count(),
        'cars_count': Car.objects.count(),
        'inspections_count': Inspection.objects.count(),
        'items_count': CarItem.objects.count(),
        'recent_logs': SystemLog.objects.select_related('user').order_by('-created_at')[:10],
    }
    return render(request, 'cars/admin_dashboard.html', context)  # این خط را اصلاح کنید

@login_required
def admin_users(request):
    if not is_admin(request.user):
        messages.error(request, 'دسترسی غیرمجاز!')
        return redirect('dashboard')
    
    users = User.objects.all().order_by('-created_at')
    
    context = {
        'users': users,
    }
    return render(request, 'cars/admin_users.html', context)  # تمپلیت صحیح

@login_required
def admin_cars(request):
    if not is_admin(request.user):
        messages.error(request, 'دسترسی غیرمجاز!')
        return redirect('dashboard')
    
    cars = Car.objects.select_related('user').all().order_by('-created_at')
    
    context = {
        'cars': cars,
    }
    return render(request, 'cars/admin_cars.html', context)  # تمپلیت صحیح

@login_required
def admin_items(request):
    if not is_admin(request.user):
        messages.error(request, 'دسترسی غیرمجاز!')
        return redirect('dashboard')
    
    items = CarItem.objects.all().order_by('car_type', 'category', 'name')
    
    if request.method == 'POST':
        form = CarItemForm(request.POST)
        if form.is_valid():
            form.save()
            add_log('افزودن قلم جدید', f'قلم جدید: {form.cleaned_data["name"]}', request.user, request)
            messages.success(request, '✅ قلم جدید با موفقیت اضافه شد')
            return redirect('admin_items')
    else:
        form = CarItemForm()
    
    context = {
        'items': items,
        'form': form,
    }
    return render(request, 'cars/admin_items.html', context)  # تمپلیت صحیح

@login_required
def admin_logs(request):
    if not is_admin(request.user):
        messages.error(request, 'دسترسی غیرمجاز!')
        return redirect('dashboard')
    
    logs = SystemLog.objects.select_related('user').all().order_by('-created_at')[:100]
    
    context = {
        'logs': logs,
    }
    return render(request, 'cars/admin_logs.html', context)  # تمپلیت صحیح

@login_required
def edit_item(request, item_id):
    if not is_admin(request.user):
        messages.error(request, 'دسترسی غیرمجاز!')
        return redirect('dashboard')
    
    item = get_object_or_404(CarItem, id=item_id)
    
    if request.method == 'POST':
        form = CarItemForm(request.POST, instance=item)
        if form.is_valid():
            form.save()
            add_log('ویرایش قلم', f'ویرایش قلم با شناسه: {item_id}', request.user, request)
            messages.success(request, '✅ قلم با موفقیت ویرایش شد')
            return redirect('admin_items')
    else:
        form = CarItemForm(instance=item)
    
    context = {
        'form': form,
        'item': item,
    }
    return render(request, 'cars/edit_item.html', context)

@login_required
def delete_item(request, item_id):
    if not is_admin(request.user):
        messages.error(request, 'دسترسی غیرمجاز!')
        return redirect('dashboard')
    
    item = get_object_or_404(CarItem, id=item_id)
    item.delete()
    add_log('حذف قلم', f'حذف قلم با شناسه: {item_id}', request.user, request)
    messages.success(request, '✅ قلم با موفقیت حذف شد')
    return redirect('admin_items')


@login_required
def car_register(request):
    """صفحه ثبت اولیه خودرو - فقط برای کاربر عادی"""
    if request.user.user_type != 'customer':
        messages.error(request, 'شما اجازه ثبت خودرو ندارید.')
        return redirect('dashboard')

    if request.method == 'POST':
        # اینجا فرم ثبت اطلاعات خودرو میاد (بعداً کاملش می‌کنیم)
        messages.success(request, 'درخواست ثبت خودرو ارسال شد. منتظر تأیید باشید.')
        return redirect('cars_list')

    return render(request, 'cars/car_register.html', {})


@login_required
def inspection_view(request, car_id):
    """نمایش جزئیات بازرسی خودرو (برای بازرس یا مدیر)"""
    car = get_object_or_404(Car, id=car_id)
    inspection = car.inspections.last() if hasattr(car, 'inspections') else None

    if not inspection:
        messages.error(request, 'بازرسی برای این خودرو انجام نشده است.')
        return redirect('inspection_list')

    context = {
        'car': car,
        'inspection': inspection,
    }
    return render(request, 'cars/inspection_detail.html', context)


@login_required
def inspection_detail(request, inspection_id):


    """نمایش جزئیات بازرسی - برای بازرس و مدیر"""
    inspection = get_object_or_404(Inspection, id=inspection_id)
    
    # بررسی دسترسی: فقط بازرس مربوطه یا مدیر می‌تواند جزئیات را ببیند
    if not (request.user == inspection.inspector or is_manager(request.user) or is_admin(request.user)):
        messages.error(request, 'شما دسترسی به این صفحه ندارید.')
        return redirect('dashboard')
    
    # دریافت آیتم‌های مفقوده
    missing_items = InspectionMissingItem.objects.filter(inspection=inspection).select_related('item')
    
    context = {
        'inspection': inspection,
        'missing_items': missing_items,
        'car': inspection.car,
    }
    return render(request, 'cars/inspection_detail.html', context)
def pending_inspections_count(request):
    """Context processor for showing pending inspections count in menu"""
    if request.user.is_authenticated and is_inspector(request.user):
        count = Car.objects.filter(
            status='inspection',
            province=request.user.province
        ).count()
        return {'pending_cars_count': count}
    return {'pending_cars_count': 0}

@login_required
def upload_excel(request):
    """صفحه آپلود فایل اکسل"""
    if request.user.user_type != 'customer':
        messages.error(request, 'شما اجازه آپلود فایل اکسل ندارید.')
        return redirect('dashboard')

    if request.method == 'POST':
        form = ExcelUploadForm(request.POST, request.FILES)
        if form.is_valid():
            excel_file = request.FILES['excel_file']
            
            # ذخیره فایل
            fs = FileSystemStorage()
            filename = fs.save(f'excel_uploads/{excel_file.name}', excel_file)
            file_path = fs.path(filename)
            
            try:
                # پردازش فایل اکسل - استفاده از تابع کامل
                result = process_complete_excel_file(file_path, request.user)
                
                if result['success']:
                    messages.success(request, 
                        f'✅ پردازش فایل با موفقیت انجام شد. {result["successful"]} خودرو ثبت شد. {result["failed"]} خطا.')
                    
                    if result['errors']:
                        # ذخیره خطاها در session برای نمایش جزئیات
                        request.session['excel_errors'] = result['errors'][:10]  # فقط 10 خطای اول
                        
                else:
                    messages.error(request, f'❌ خطا در پردازش فایل: {result["error"]}')
                    
            except Exception as e:
                messages.error(request, f'❌ خطا در پردازش فایل: {str(e)}')
            
            # حذف فایل موقت
            if os.path.exists(file_path):
                os.remove(file_path)
                
            return redirect('upload_excel')
    else:
        form = ExcelUploadForm()
    
    # نمایش خطاهای جلسه قبلی
    excel_errors = request.session.pop('excel_errors', [])
    
    context = {
        'form': form,
        'excel_errors': excel_errors
    }
    return render(request, 'cars/upload_excel.html', context)

def process_excel_file(file_path, user):
    """پردازش فایل اکسل و ثبت خودروها"""
    try:
        # خواندن فایل اکسل
        df = pd.read_excel(file_path)
        
        # بررسی ساختار فایل
        required_columns = ['مالک', 'پلاک', 'شماره_بدنه', 'سیستم', 'نوع_خودرو', 
                          'مدل', 'شماره_موتور', 'رنگ', 'ظرفیت', 'قیمت_پایه']
        
        missing_columns = [col for col in required_columns if col not in df.columns]
        if missing_columns:
            return {
                'success': False,
                'error': f'ستون‌های ضروری وجود ندارد: {", ".join(missing_columns)}'
            }
        
        successful = 0
        failed = 0
        errors = []
        
        for index, row in df.iterrows():
            try:
                # بررسی اینکه خودرو با این شماره بدنه وجود ندارد
                if Car.objects.filter(vin=row['شماره_بدنه']).exists():
                    errors.append(f"ردیف {index+2}: خودرو با شماره بدنه {row['شماره_بدنه']} قبلاً ثبت شده است")
                    failed += 1
                    continue
                
                # ایجاد یا گرفتن CarType
                car_type_name = row['نوع_خودرو']
                car_type_obj, created = CarType.objects.get_or_create(type_name=car_type_name)
                
                # ایجاد خودرو
                car = Car.objects.create(
                    owner_name=row['مالک'],
                    plate_number=row['پلاک'],
                    vin=row['شماره_بدنه'],
                    system=row['سیستم'],
                    car_type=car_type_obj,
                    model=row['مدل'],
                    engine_number=row['شماره_موتور'],
                    color=row['رنگ'],
                    capacity=int(row['ظرفیت']),
                    base_price=float(row['قیمت_پایه']),
                    user=user,
                    province=user.province,
                    status='inspection'
                )
                
                successful += 1
                
            except Exception as e:
                errors.append(f"ردیف {index+2}: {str(e)}")
                failed += 1
        
        return {
            'success': True,
            'successful': successful,
            'failed': failed,
            'errors': errors
        }
        
    except Exception as e:
        return {
            'success': False,
            'error': str(e)
        }


def process_complete_excel_file(file_path, user):
    """پردازش فایل اکسل کامل با تمام اطلاعات"""
    try:
        # خواندن فایل اکسل
        df = pd.read_excel(file_path)
        
        # بررسی ساختار فایل
        required_columns = [
            'مالک', 'پلاک', 'شماره_بدنه', 'سیستم', 'نوع_خودرو', 
            'مدل', 'شماره_موتور', 'رنگ', 'ظرفیت', 'قیمت_پایه',
            'خریدار_نام', 'خریدار_تلفن', 'واسطه_نام', 'واسطه_تلفن',
            'منطقه_پارکینگ', 'شماره_پارکینگ', 'تاریخ_پارک', 'زمان_پارک'
        ]
        
        missing_columns = [col for col in required_columns if col not in df.columns]
        if missing_columns:
            return {
                'success': False,
                'error': f'ستون‌های ضروری وجود ندارد: {", ".join(missing_columns)}'
            }
        
        successful = 0
        failed = 0
        errors = []
        
        for index, row in df.iterrows():
            try:
                # بررسی اینکه خودرو با این شماره بدنه وجود ندارد
                if Car.objects.filter(vin=row['شماره_بدنه']).exists():
                    errors.append(f"ردیف {index+2}: خودرو با شماره بدنه {row['شماره_بدنه']} قبلاً ثبت شده است")
                    failed += 1
                    continue
                
                # ایجاد یا گرفتن CarType
                car_type_name = row['نوع_خودرو']
                car_type_obj, created = CarType.objects.get_or_create(type_name=car_type_name)
                
                # ایجاد یا گرفتن Buyer
                buyer, buyer_created = Buyer.objects.get_or_create(
                    name=row['خریدار_نام'],
                    defaults={
                        'phone': row['خریدار_تلفن'],
                        'province': user.province
                    }
                )
                
                # ایجاد یا گرفتن Intermediary
                intermediary, intermediary_created = Intermediary.objects.get_or_create(
                    name=row['واسطه_نام'],
                    defaults={
                        'phone': row['واسطه_تلفن'],
                        'province': user.province
                    }
                )
                
                # ایجاد خودرو
                car = Car.objects.create(
                    owner_name=row['مالک'],
                    plate_number=row['پلاک'],
                    vin=row['شماره_بدنه'],
                    system=row['سیستم'],
                    car_type=car_type_obj,
                    model=row['مدل'],
                    engine_number=row['شماره_موتور'],
                    color=row['رنگ'],
                    capacity=int(row['ظرفیت']),
                    base_price=float(row['قیمت_پایه']),
                    user=user,
                    buyer=buyer,
                    intermediary=intermediary,
                    province=user.province,
                    status='inspection'
                )
                
                # ایجاد پارکینگ
                Parking.objects.create(
                    car=car,
                    parking_zone=row['منطقه_پارکینگ'],
                    parking_number=row['شماره_پارکینگ'],
                    park_date=datetime.strptime(row['تاریخ_پارک'], '%Y-%m-%d').date(),
                    park_time=datetime.strptime(row['زمان_پارک'], '%H:%M').time(),
                    province=user.province
                )
                
                successful += 1
                
            except Exception as e:
                errors.append(f"ردیف {index+2}: {str(e)}")
                failed += 1
        
        return {
            'success': True,
            'successful': successful,
            'failed': failed,
            'errors': errors
        }
        
    except Exception as e:
        return {
            'success': False,
            'error': str(e)
        }

@login_required
def download_excel_template(request):
    """دانلود فایل نمونه اکسل کامل"""
    try:
        # ایجاد داده‌های نمونه کامل
        sample_data = {
            # اطلاعات پایه خودرو
            'مالک': ['علی محمدی', 'رضا احمدی', 'محمد حسینی'],
            'پلاک': ['12ب12345', '34ج54321', '56ف12345'],
            'شماره_بدنه': ['ABC12345678901234', 'DEF98765432109876', 'GHI12398745632147'],
            'سیستم': ['EF7', 'TU5', 'XU7'],
            'نوع_خودرو': ['پراید', 'پژو 206', 'پژو 405'],
            'مدل': ['131', 'تیپ 2', 'SLX'],
            'شماره_موتور': ['ENG123456789', 'ENG987654321', 'ENG456123789'],
            'رنگ': ['سفید', 'مشکی', 'نقره‌ای'],
            'ظرفیت': [4, 5, 5],
            'قیمت_پایه': [500000000, 800000000, 700000000],
            
            # اطلاعات خریدار
            'خریدار_نام': ['خریدار قزوین ۱', 'خریدار تهران ۱', 'خریدار کرمان ۱'],
            'خریدار_تلفن': ['09123456789', '09123456790', '09123456791'],
            
            # اطلاعات واسطه
            'واسطه_نام': ['واسطه قزوین ۱', 'واسطه تهران １', 'واسطه کرمان １'],
            'واسطه_تلفن': ['09127654321', '09127654322', '09127654323'],
            
            # اطلاعات حقوقی
            'ذینفع': ['ذینفع ۱', 'ذینفع ۲', 'ذینفع ۳'],
            'وکالت_نامه': ['وکالت-001', 'وکالت-002', 'وکالت-003'],
            
            # اطلاعات پارکینگ
            'منطقه_پارکینگ': ['A', 'B', 'C'],
            'شماره_پارکینگ': ['A101', 'B205', 'C310'],
            'تاریخ_پارک': [
                (datetime.now() + timedelta(days=1)).strftime('%Y-%m-%d'),
                (datetime.now() + timedelta(days=2)).strftime('%Y-%m-%d'),
                (datetime.now() + timedelta(days=3)).strftime('%Y-%m-%d')
            ],
            'زمان_پارک': ['08:30', '09:15', '10:00']
        }

        # ایجاد DataFrame
        df = pd.DataFrame(sample_data)

        # ایجاد پاسخ فایل
        response = HttpResponse(content_type='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')
        response['Content-Disposition'] = 'attachment; filename="car_template_complete.xlsx"'

        with pd.ExcelWriter(response, engine='openpyxl') as writer:
            # sheet داده‌ها
            df.to_excel(writer, sheet_name='خودروها', index=False)
            
            # فرمت‌دهی ستون‌ها
            worksheet = writer.sheets['خودروها']
            
            # تنظیم عرض ستون‌ها
            column_widths = {
                'A': 15,   # مالک
                'B': 12,   # پلاک
                'C': 20,   # شماره_بدنه
                'D': 8,    # سیستم
                'E': 12,   # نوع_خودرو
                'F': 10,   # مدل
                'G': 15,   # شماره_موتور
                'H': 10,   # رنگ
                'I': 8,    # ظرفیت
                'J': 15,   # قیمت_پایه
                'K': 15,   # خریدار_نام
                'L': 12,   # خریدار_تلفن
                'M': 15,   # واسطه_نام
                'N': 12,   # واسطه_تلفن
                'O': 12,   # ذینفع
                'P': 12,   # وکالت_نامه
                'Q': 12,   # منطقه_پارکینگ
                'R': 12,   # شماره_پارکینگ
                'S': 12,   # تاریخ_پارک
                'T': 10    # زمان_پارک
            }
            
            for col, width in column_widths.items():
                worksheet.column_dimensions[col].width = width
            
            # sheet راهنما
            instructions_data = {
                'ستون': [
                    'مالک', 'پلاک', 'شماره_بدنه', 'سیستم', 'نوع_خودرو', 'مدل', 'شماره_موتور', 
                    'رنگ', 'ظرفیت', 'قیمت_پایه', 'خریدار_نام', 'خریدار_تلفن', 'واسطه_نام', 
                    'واسطه_تلفن', 'ذینفع', 'وکالت_نامه', 'منطقه_پارکینگ', 'شماره_پارکینگ', 
                    'تاریخ_پارک', 'زمان_پارک'
                ],
                'توضیحات': [
                    'نام مالک خودرو (برگه سبز) - اجباری',
                    'شماره پلاک خودرو - اجباری',
                    'شماره VIN یا شماره بدنه (یکتا) - اجباری',
                    'سیستم خودرو - اجباری',
                    'نوع خودرو (پراید، پژو، ...) - اجباری',
                    'مدل خودرو - اجباری',
                    'شماره موتور - اجباری',
                    'رنگ خودرو - اجباری',
                    'تعداد سرنشین - اجباری',
                    'قیمت پایه به ریال (بدون جداکننده) - اجباری',
                    'نام خریدار - اجباری',
                    'شماره تلفن خریدار - اجباری',
                    'نام واسطه - اجباری',
                    'شماره تلفن واسطه - اجباری',
                    'نام ذینفع - اختیاری',
                    'شماره وکالت‌نامه - اختیاری',
                    'منطقه پارکینگ (A, B, C) - اجباری',
                    'شماره جای پارک - اجباری',
                    'تاریخ پارک (YYYY-MM-DD) - اجباری',
                    'زمان پارک (HH:MM) - اجباری'
                ],
                'نمونه': [
                    'علی محمدی',
                    '12ب12345',
                    'ABC12345678901234',
                    'EF7',
                    'پراید',
                    '131',
                    'ENG123456789',
                    'سفید',
                    '4',
                    '500000000',
                    'خریدار قزوین ۱',
                    '09123456789',
                    'واسطه قزوین ۱',
                    '09127654321',
                    'ذینفع ۱',
                    'وکالت-001',
                    'A',
                    'A101',
                    (datetime.now() + timedelta(days=1)).strftime('%Y-%m-%d'),
                    '08:30'
                ]
            }
            
            instructions_df = pd.DataFrame(instructions_data)
            instructions_df.to_excel(writer, sheet_name='راهنما', index=False)
            
            # فرمت‌دهی sheet راهنما
            worksheet_help = writer.sheets['راهنما']
            worksheet_help.column_dimensions['A'].width = 15
            worksheet_help.column_dimensions['B'].width = 35
            worksheet_help.column_dimensions['C'].width = 20

        # ثبت لاگ
        add_log('دانلود فایل نمونه', 'کاربر فایل نمونه اکسل را دانلود کرد', request.user)
        
        return response

    except Exception as e:
        messages.error(request, f'خطا در ایجاد فایل نمونه: {str(e)}')
        return redirect('upload_excel')

@login_required
def pending_inspections(request):
    """لیست خودروهای در انتظار بازرسی برای بازرس"""
    if not is_inspector(request.user):
        messages.error(request, 'دسترسی غیرمجاز! فقط بازرسان می‌توانند این صفحه را مشاهده کنند.')
        return redirect('dashboard')
    
    # خودروهای با وضعیت 'inspection' در استان بازرس
    cars = Car.objects.filter(
        status='inspection',
        province=request.user.province
    ).select_related('car_type', 'user').order_by('-created_at')
    
    context = {
        'cars': cars,
        'title': 'خودروهای در انتظار بازرسی'
    }
    return render(request, 'cars/pending_inspections.html', context)