from django.urls import path
from . import views

urlpatterns = [
    # احراز هویت
    path('', views.login_view, name='login'),
    path('register/', views.register_view, name='register'),
    path('logout/', views.logout_view, name='logout'),
    path('dashboard/', views.dashboard, name='dashboard'),
    
    # ثبت خودرو
    path('start-sale/', views.start_sale, name='start_sale'),
    path('chassis-check/', views.chassis_check, name='chassis_check'),
    path('car-info/', views.car_info, name='car_info'),
    path('intermediary/', views.intermediary_view, name='intermediary'),
    path('parking/', views.parking_view, name='parking'),
    
    # لیست‌ها
    path('cars/', views.cars_list, name='cars_list'),
    path('my-cars/', views.cars_list, name='my_cars'),
    
    #بازرسی
    path('inspections/', views.inspection_list, name='inspection_list'),
    path('pending-inspections/', views.pending_inspections, name='pending_inspections'),  # اضافه شده
    path('inspect-car/<int:car_id>/', views.inspect_car, name='inspect_car'),
    path('inspection-detail/<int:inspection_id>/', views.inspection_detail, name='inspection_detail'),

    
    # مالی
    path('finance-list/', views.finance_list, name='finance_list'),
    path('finance/<int:car_id>/', views.finance_view, name='finance'),
    
    # مدیر سیستم
    path('manager-approval/', views.manager_approval_list, name='manager_approval_list'),
    path('manager-approval/<int:car_id>/', views.manager_approval_detail, name='manager_approval_detail'),
    
    # پنل مدیریت
    path('admin-dashboard/', views.admin_dashboard, name='admin_dashboard'),
    path('admin-users/', views.admin_users, name='admin_users'),
    path('admin-cars/', views.admin_cars, name='admin_cars'),
    path('admin-items/', views.admin_items, name='admin_items'),
    path('admin-logs/', views.admin_logs, name='admin_logs'),
    path('edit-item/<int:item_id>/', views.edit_item, name='edit_item'),
    path('delete-item/<int:item_id>/', views.delete_item, name='delete_item'),
    
    # URL های قدیمی برای سازگاری (اختیاری)
    path('manager/<int:car_id>/', views.manager_approval_detail, name='manager_approval'),

    # آپلود اکسل
    path('upload-excel/', views.upload_excel, name='upload_excel') ,
    path('download-excel-template/', views.download_excel_template, name='download_excel_template'),
]