from django import template

register = template.Library()

@register.filter
def dictsum(items, attribute):
    """جمع‌زدن مقادیر یک attribute از مجموعه‌ای از آبجکت‌ها"""
    try:
        return sum(getattr(item, attribute, 0) for item in items)
    except (TypeError, AttributeError):
        return 0

@register.filter
def upper(value):
    """تبدیل رشته به حروف بزرگ"""
    return str(value).upper() if value else ''

@register.filter
def get_item(dictionary, key):
    """دریافت مقدار از دیکشنری با کلید"""
    return dictionary.get(key, '')