# Generated by Django 4.2.7 on 2025-11-09 21:14

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=150, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('phone', models.CharField(max_length=11, unique=True)),
                ('national_code', models.CharField(max_length=10, unique=True)),
                ('shenasnameh_code', models.CharField(max_length=10)),
                ('province', models.CharField(choices=[('قزوین', 'قزوین'), ('تهران', 'تهران'), ('کرمان', 'کرمان')], max_length=20)),
                ('user_type', models.CharField(choices=[('user', 'کاربر عادی'), ('intermediary', 'واسطه'), ('inspector', 'بازرس'), ('admin', 'مدیر سیستم')], default='user', max_length=20)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Buyer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('province', models.CharField(choices=[('قزوین', 'قزوین'), ('تهران', 'تهران'), ('کرمان', 'کرمان')], max_length=20)),
                ('phone', models.CharField(blank=True, max_length=11, null=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
            ],
        ),
        migrations.CreateModel(
            name='Car',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('chassis_number', models.CharField(max_length=100, unique=True)),
                ('owner_name', models.CharField(max_length=200)),
                ('plate_number', models.CharField(max_length=20)),
                ('vin', models.CharField(max_length=100)),
                ('system', models.CharField(max_length=100)),
                ('car_type', models.CharField(max_length=100)),
                ('model', models.CharField(max_length=100)),
                ('engine_number', models.CharField(max_length=100)),
                ('color', models.CharField(max_length=50)),
                ('capacity', models.IntegerField()),
                ('base_price', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('zinefaa', models.CharField(blank=True, max_length=200, null=True)),
                ('vekalatnameh', models.CharField(blank=True, max_length=200, null=True)),
                ('status', models.CharField(choices=[('pending', 'در انتظار'), ('approved', 'تایید شده'), ('rejected', 'رد شده')], default='pending', max_length=20)),
                ('province', models.CharField(choices=[('قزوین', 'قزوین'), ('تهران', 'تهران'), ('کرمان', 'کرمان')], max_length=20)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('buyer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='cars.buyer')),
            ],
        ),
        migrations.CreateModel(
            name='CarItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('category', models.CharField(choices=[('essential', 'ضروری'), ('optional', 'اختیاری')], default='essential', max_length=20)),
                ('price', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('car_type', models.CharField(default='general', max_length=100)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
            ],
        ),
        migrations.CreateModel(
            name='CarType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type_name', models.CharField(max_length=100, unique=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
            ],
        ),
        migrations.CreateModel(
            name='Inspection',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('base_price', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('total_deduction', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('final_price', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('notes', models.TextField(blank=True, null=True)),
                ('inspection_date', models.DateField()),
                ('inspection_time', models.TimeField()),
                ('overall_status', models.CharField(choices=[('approved', 'تایید شده'), ('rejected', 'رد شده')], max_length=20)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('car', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cars.car')),
                ('inspector', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Intermediary',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('province', models.CharField(choices=[('قزوین', 'قزوین'), ('تهران', 'تهران'), ('کرمان', 'کرمان')], max_length=20)),
                ('phone', models.CharField(blank=True, max_length=11, null=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
            ],
        ),
        migrations.CreateModel(
            name='SystemLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action', models.CharField(max_length=200)),
                ('description', models.TextField(blank=True, null=True)),
                ('ip_address', models.GenericIPAddressField(blank=True, null=True)),
                ('user_agent', models.TextField(blank=True, null=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Parking',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('parking_zone', models.CharField(choices=[('A', 'A'), ('B', 'B'), ('C', 'C')], max_length=1)),
                ('parking_number', models.CharField(max_length=10)),
                ('park_date', models.DateField()),
                ('park_time', models.TimeField()),
                ('province', models.CharField(choices=[('قزوین', 'قزوین'), ('تهران', 'تهران'), ('کرمان', 'کرمان')], max_length=20)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('car', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cars.car')),
            ],
        ),
        migrations.CreateModel(
            name='InspectionMissingItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('item_price', models.DecimalField(decimal_places=2, default=0, max_digits=15)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('inspection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cars.inspection')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cars.caritem')),
            ],
        ),
        migrations.AddField(
            model_name='car',
            name='intermediary',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='cars.intermediary'),
        ),
        migrations.AddField(
            model_name='car',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddConstraint(
            model_name='parking',
            constraint=models.UniqueConstraint(fields=('parking_zone', 'parking_number', 'province', 'park_date'), name='unique_parking'),
        ),
    ]
