from django import forms
from django.contrib.auth.forms import UserCreationForm
from .models import User, CarItem, Parking, Inspection
from django import forms
from .models import Car, Inspection, FinanceReview, ManagerApproval
from django import forms
from django.contrib.auth.forms import UserCreationForm
from .models import User, CarItem, Parking, Inspection
from django import forms
from .models import Car, Inspection, FinanceReview, ManagerApproval
import os  # این خط را اضافه کنید


class InspectionForm(forms.Form):
    # حذف فیلدهایی که در مدل وجود ندارند
    notes = forms.CharField(widget=forms.Textarea, required=False, label="توضیحات بازرسی")
    overall_status = forms.ChoiceField(choices=Inspection.STATUS_CHOICES, required=True, label="وضعیت کلی")
    missing_items = forms.MultipleChoiceField(
        required=False, 
        widget=forms.CheckboxSelectMultiple,
        label="آیتم‌های مفقوده"
    )
    
    def __init__(self, *args, **kwargs):
        car_items = kwargs.pop('car_items', None)
        super().__init__(*args, **kwargs)
        if car_items:
            self.fields['missing_items'].choices = [
                (item.id, f"{item.name} - {item.price} ریال") 
                for item in car_items
            ]



class FinanceReviewForm(forms.ModelForm):
    class Meta:
        model = FinanceReview
        fields = ['suggested_price', 'notes']
        widgets = {
            'notes': forms.Textarea(attrs={'rows': 3}),
        }

class ManagerApprovalForm(forms.ModelForm):
    class Meta:
        model = ManagerApproval
        fields = ['approved', 'notes']
        widgets = {
            'approved': forms.RadioSelect(choices=[(True, 'تأیید'), (False, 'رد')]),
            'notes': forms.Textarea(attrs={'rows': 3}),
        }

class CarForm(forms.ModelForm):
    class Meta:
        model = Car
        fields = ['owner_name', 'plate_number', 'vin', 'system', 'car_type',
                  'model', 'engine_number', 'color', 'capacity', 'base_price']


class InspectionForm(forms.ModelForm):
    class Meta:
        model = Inspection
        fields = ['notes',  'status']


class FinanceReviewForm(forms.ModelForm):
    class Meta:
        model = FinanceReview
        fields = ['suggested_price', 'notes']


class ManagerApprovalForm(forms.ModelForm):
    class Meta:
        model = ManagerApproval
        fields = ['approved', 'notes']



class UserRegistrationForm(UserCreationForm):
    first_name = forms.CharField(max_length=100, required=True)
    last_name = forms.CharField(max_length=100, required=True)
    phone = forms.CharField(max_length=11, required=True)
    national_code = forms.CharField(max_length=10, required=True)
    shenasnameh_code = forms.CharField(max_length=10, required=True)
    province = forms.ChoiceField(choices=User.PROVINCE_CHOICES, required=True)
    user_type = forms.ChoiceField(choices=User.USER_TYPE_CHOICES, required=True)
    
    class Meta:
        model = User
        fields = ['first_name', 'last_name', 'phone', 'national_code', 
                 'shenasnameh_code', 'province', 'user_type', 'password1', 'password2']

class LoginForm(forms.Form):
    national_code = forms.CharField(max_length=10, required=True)
    shenasnameh_code = forms.CharField(max_length=10, required=True)

class ChassisCheckForm(forms.Form):
    chassis_number = forms.CharField(max_length=100, required=True)

class CarInfoForm(forms.Form):
    owner_name = forms.CharField(max_length=200, required=True)
    plate_number = forms.CharField(max_length=20, required=True)
    vin = forms.CharField(max_length=100, required=True)
    system = forms.CharField(max_length=100, required=True)
    car_type = forms.CharField(max_length=100, required=True)
    model = forms.CharField(max_length=100, required=True)
    engine_number = forms.CharField(max_length=100, required=True)
    color = forms.CharField(max_length=50, required=True)
    capacity = forms.IntegerField(required=True, min_value=1)
    base_price = forms.DecimalField(required=True, max_digits=15, decimal_places=2)

class IntermediaryForm(forms.Form):
    buyer_id = forms.IntegerField(required=True)
    intermediary_id = forms.IntegerField(required=True)
    zinefaa = forms.CharField(max_length=200, required=False)
    vekalatnameh = forms.CharField(max_length=200, required=False)

class ParkingForm(forms.Form):
    parking_zone = forms.ChoiceField(choices=Parking.ZONE_CHOICES, required=True)
    parking_number = forms.CharField(max_length=10, required=True)
    park_date = forms.DateField(required=True)
    park_time = forms.TimeField(required=True)

class InspectionForm(forms.Form):
    car_id = forms.IntegerField(required=True)
    overall_status = forms.ChoiceField(choices=Inspection.STATUS_CHOICES, required=True)
    notes = forms.CharField(widget=forms.Textarea, required=False)
    inspection_date = forms.DateField(required=True)
    inspection_time = forms.TimeField(required=True)
    missing_items = forms.MultipleChoiceField(required=False, widget=forms.CheckboxSelectMultiple)

class CarItemForm(forms.ModelForm):
    class Meta:
        model = CarItem
        fields = ['name', 'category', 'price', 'car_type', 'is_active']

class ExcelUploadForm(forms.Form):
    excel_file = forms.FileField(
        label='فایل اکسل',
        help_text='فایل اکسل حاوی اطلاعات خودروها را انتخاب کنید (فرمت‌های xlsx, xls)',
        widget=forms.FileInput(attrs={
            'accept': '.xlsx, .xls',
            'class': 'form-control'
        })
    )
    
    def clean_excel_file(self):
        excel_file = self.cleaned_data.get('excel_file')
        if excel_file:
            # بررسی پسوند فایل
            valid_extensions = ['.xlsx', '.xls']
            ext = os.path.splitext(excel_file.name)[1].lower()
            if ext not in valid_extensions:
                raise forms.ValidationError('فقط فایل‌های اکسل با پسوند xlsx یا xls مجاز هستند.')
            
            # بررسی سایز فایل (حداکثر 10MB)
            if excel_file.size > 10 * 1024 * 1024:
                raise forms.ValidationError('حجم فایل نباید بیشتر از 10 مگابایت باشد.')
                
        return excel_file