from django.contrib import admin
from .models import User, Car, CarType, Buyer, Intermediary, Parking, CarItem, Inspection, FinanceReview, ManagerApproval, SystemLog
from django.contrib import admin
from .models import Inspection

# ==========================
# User Admin
# ==========================
@admin.register(User)
class CustomUserAdmin(admin.ModelAdmin):
    list_display = ['username', 'phone', 'national_code', 'province', 'user_type', 'created_at']
    list_filter = ['user_type', 'province']
    search_fields = ['username', 'phone', 'national_code']

# ==========================
# Car Admin
# ==========================
@admin.register(Car)
class CarAdmin(admin.ModelAdmin):
    list_display = ['owner_name', 'plate_number', 'vin', 'car_type', 'status', 'province', 'created_at']
    list_filter = ['status', 'province', 'car_type']
    search_fields = ['owner_name', 'plate_number', 'vin']

# ==========================
# Inspection Admin
# ==========================
@admin.register(Inspection)
class InspectionAdmin(admin.ModelAdmin):
    list_display = ('car', 'get_inspector_type', 'status', 'get_final_price', 'created_at')
    list_filter = ('status', 'created_at')

    def get_inspector_type(self, obj):
        return obj.inspector.user_type
    get_inspector_type.short_description = 'نوع بازرس'
    
    def get_final_price(self, obj):
        # اگر می‌خواهید قیمت نهایی از Car گرفته شود
        return obj.car.base_price
    get_final_price.short_description = 'قیمت نهایی'
# ==========================
# بقیه مدل‌ها
# ==========================
admin.site.register(CarType)
admin.site.register(Buyer)
admin.site.register(Intermediary)
admin.site.register(Parking)
admin.site.register(CarItem)
admin.site.register(FinanceReview)
admin.site.register(ManagerApproval)
admin.site.register(SystemLog)
