import os
import pathlib

def gather_project_files(output_file="project_content.txt"):
    """
    تمام فایل‌های متنی پروژه را در یک فایل خروجی جمع‌آوری می‌کند
    """
    # تعریف پسوندهای فایل‌های مورد نظر
    text_extensions = {
        '.py', '.html', '.css', '.js', '.txt', '.md', '.json', '.xml',
        '.yaml', '.yml', '.csv', '.tsv', '.sql', '.php', '.java', '.c', '.cpp',
        '.h', '.cs', '.rb', '.go', '.rs', '.swift', '.kt', '.scala', '.r',
        '.m', '.sql', '.sh', '.bash', '.zsh', '.fish', '.ps1', '.bat', '.cmd'
    }
    
    # فایل‌هایی که باید نادیده گرفته شوند
    ignore_dirs = {'.git', '__pycache__', 'node_modules', 'venv', 'env', '.idea', '.vscode'}
    ignore_files = {output_file, '.gitignore', '.DS_Store'}
    
    with open(output_file, 'w', encoding='utf-8') as outfile:
        # پیمایش پوشه‌ها و زیرپوشه‌ها
        for root, dirs, files in os.walk('.'):
            # حذف پوشه‌های ناخواسته
            dirs[:] = [d for d in dirs if d not in ignore_dirs]
            
            for file in files:
                file_path = pathlib.Path(root) / file
                
                # نادیده گرفتن فایل‌های خاص
                if file in ignore_files:
                    continue
                
                # بررسی پسوند فایل
                if file_path.suffix.lower() in text_extensions:
                    try:
                        # نوشتن نام فایل به عنوان جداکننده
                        outfile.write(f"\n{'='*80}\n")
                        outfile.write(f"FILE: {file_path}\n")
                        outfile.write(f"{'='*80}\n\n")
                        
                        # خواندن و نوشتن محتوای فایل
                        with open(file_path, 'r', encoding='utf-8') as infile:
                            content = infile.read()
                            outfile.write(content)
                            outfile.write('\n')
                            
                    except UnicodeDecodeError:
                        # اگر فایل UTF-8 نباشد، با خطای دیگر امتحان کنیم
                        try:
                            with open(file_path, 'r', encoding='latin-1') as infile:
                                content = infile.read()
                                outfile.write(content)
                                outfile.write('\n')
                        except Exception as e:
                            outfile.write(f"[ERROR: Could not read file - {e}]\n")
                            
                    except Exception as e:
                        outfile.write(f"[ERROR: {e}]\n")
    
    print(f"تمامی فایل‌ها در {output_file} ذخیره شدند.")

def gather_all_files(output_file="project_content.txt"):
    """
    تمام فایل‌های پروژه را بدون در نظر گرفتن پسوند جمع‌آوری می‌کند
    """
    ignore_dirs = {'.git', '__pycache__', 'node_modules', 'venv', 'env', '.idea', '.vscode'}
    ignore_files = {output_file, '.gitignore', '.DS_Store'}
    
    with open(output_file, 'w', encoding='utf-8') as outfile:
        for root, dirs, files in os.walk('.'):
            dirs[:] = [d for d in dirs if d not in ignore_dirs]
            
            for file in files:
                file_path = pathlib.Path(root) / file
                
                if file in ignore_files:
                    continue
                
                try:
                    outfile.write(f"\n{'='*80}\n")
                    outfile.write(f"FILE: {file_path}\n")
                    outfile.write(f"{'='*80}\n\n")
                    
                    # سعی در خواندن به عنوان فایل متنی
                    with open(file_path, 'r', encoding='utf-8') as infile:
                        content = infile.read()
                        outfile.write(content)
                        outfile.write('\n')
                        
                except UnicodeDecodeError:
                    try:
                        with open(file_path, 'r', encoding='latin-1') as infile:
                            content = infile.read()
                            outfile.write(content)
                            outfile.write('\n')
                    except:
                        outfile.write(f"[BINARY FILE - Cannot display content]\n")
                        
                except Exception as e:
                    outfile.write(f"[ERROR: {e}]\n")
    
    print(f"تمامی فایل‌ها در {output_file} ذخیره شدند.")

# اجرای تابع اصلی
if __name__ == "__main__":
    # برای فایل‌های متنی رایج
    gather_project_files("project_content.txt")
    
    # اگر می‌خواهید تمام فایل‌ها را داشته باشید (حتی باینری)
    # gather_all_files("all_project_files.txt")