import pandas as pd
from datetime import datetime, timedelta

# ایجاد داده‌های نمونه کامل
sample_data = {
    # اطلاعات پایه خودرو
    'مالک': ['علی محمدی', 'رضا احمدی', 'محمد حسینی', 'فاطمه کریمی', 'حسین رضایی', 
             'زهرا موسوی', 'احمد نوروزی', 'مریم جعفری', 'محسن کاظمی', 'سارا امینی'],
    
    'پلاک': ['12ب12345', '34ج54321', '56ف12345', '78ل67890', '90م54321',
             '11ن12345', '22س67890', '33ع12345', '44ق67890', '55ر12345'],
    
    'شماره_بدنه': ['ABC12345678901234', 'DEF98765432109876', 'GHI12398745632147', 
                   'JKL78945612365478', 'MNO32165498712345', 'PQR65498732165498',
                   'STU98732165498732', 'VWX12378945612378', 'YZA45612378945612', 
                   'BCD78945612378945'],
    
    'سیستم': ['EF7', 'TU5', 'XU7', 'EF7', 'TU5', 'XU7', 'EF7', 'TU5', 'XU7', 'EF7'],
    
    'نوع_خودرو': ['پراید', 'پژو 206', 'پژو 405', 'پراید', 'پژو پارس', 'سمند', 
                  'تیبا', 'دنا', 'کوییک', 'پراید'],
    
    'مدل': ['131', 'تیپ 2', 'SLX', '111', 'GLX', 'SX', '2', 'پلاس', 'R', '132'],
    
    'شماره_موتور': ['ENG123456789', 'ENG987654321', 'ENG456123789', 'ENG789456123',
                    'ENG321654987', 'ENG654987321', 'ENG987321654', 'ENG123789456',
                    'ENG456123789', 'ENG789456123'],
    
    'رنگ': ['سفید', 'مشکی', 'نقره‌ای', 'آبی', 'طلایی', 'مشکی', 'سفید', 'نقره‌ای', 'قرمز', 'سبز'],
    
    'ظرفیت': [4, 5, 5, 4, 5, 5, 5, 5, 5, 4],
    
    'قیمت_پایه': [500000000, 800000000, 700000000, 450000000, 750000000, 
                   900000000, 550000000, 950000000, 600000000, 480000000],
    
    # اطلاعات خریدار
    'خریدار_نام': ['خریدار قزوین ۱', 'خریدار تهران ۱', 'خریدار کرمان ۱', 'خریدار قزوین ۲',
                   'خریدار تهران ۲', 'خریدار کرمان ２', 'خریدار قزوین ３', 'خریدار تهران ３',
                   'خریدار کرمان ３', 'خریدار قزوین ４'],
    
    'خریدار_تلفن': ['09123456789', '09123456790', '09123456791', '09123456792',
                    '09123456793', '09123456794', '09123456795', '09123456796',
                    '09123456797', '09123456798'],
    
    # اطلاعات واسطه
    'واسطه_نام': ['واسطه قزوین ۱', 'واسطه تهران １', 'واسطه کرمان １', 'واسطه قزوین ２',
                  'واسطه تهران ２', 'واسطه کرمان ２', 'واسطه قزوین ３', 'واسطه تهران ３',
                  'واسطه کرمان ３', 'واسطه قزوین ４'],
    
    'واسطه_تلفن': ['09127654321', '09127654322', '09127654323', '09127654324',
                   '09127654325', '09127654326', '09127654327', '09127654328',
                   '09127654329', '09127654330'],
    
    # اطلاعات حقوقی
    'ذینفع': ['ذینفع ۱', 'ذینفع ۲', 'ذینفع ۳', 'ذینفع ４', 'ذینفع ５', 
              'ذینفع ６', 'ذینفع ７', 'ذینفع ８', 'ذینفع ９', 'ذینفع １０'],
    
    'وکالت_نامه': ['وکالت-001', 'وکالت-002', 'وکالت-003', 'وکالت-004', 'وکالت-005',
                   'وکالت-006', 'وکالت-007', 'وکالت-008', 'وکالت-009', 'وکالت-010'],
    
    # اطلاعات پارکینگ
    'منطقه_پارکینگ': ['A', 'B', 'C', 'A', 'B', 'C', 'A', 'B', 'C', 'A'],
    
    'شماره_پارکینگ': ['A101', 'B205', 'C310', 'A102', 'B206', 'C311', 'A103', 'B207', 'C312', 'A104'],
    
    'تاریخ_پارک': [
        (datetime.now() + timedelta(days=1)).strftime('%Y-%m-%d'),
        (datetime.now() + timedelta(days=2)).strftime('%Y-%m-%d'),
        (datetime.now() + timedelta(days=3)).strftime('%Y-%m-%d'),
        (datetime.now() + timedelta(days=1)).strftime('%Y-%m-%d'),
        (datetime.now() + timedelta(days=2)).strftime('%Y-%m-%d'),
        (datetime.now() + timedelta(days=3)).strftime('%Y-%m-%d'),
        (datetime.now() + timedelta(days=1)).strftime('%Y-%m-%d'),
        (datetime.now() + timedelta(days=2)).strftime('%Y-%m-%d'),
        (datetime.now() + timedelta(days=3)).strftime('%Y-%m-%d'),
        (datetime.now() + timedelta(days=1)).strftime('%Y-%m-%d')
    ],
    
    'زمان_پارک': ['08:30', '09:15', '10:00', '08:45', '09:30', '10:15', '08:30', '09:15', '10:00', '08:45']
}

# ایجاد DataFrame
df = pd.DataFrame(sample_data)

# ذخیره به صورت فایل اکسل
with pd.ExcelWriter('complete_car_test_data.xlsx', engine='openpyxl') as writer:
    df.to_excel(writer, sheet_name='خودروها', index=False)
    
    # فرمت‌دهی ستون‌ها
    worksheet = writer.sheets['خودروها']
    
    # تنظیم عرض ستون‌ها
    column_widths = {
        'A': 15,   # مالک
        'B': 12,   # پلاک
        'C': 20,   # شماره_بدنه
        'D': 8,    # سیستم
        'E': 12,   # نوع_خودرو
        'F': 10,   # مدل
        'G': 15,   # شماره_موتور
        'H': 10,   # رنگ
        'I': 8,    # ظرفیت
        'J': 15,   # قیمت_پایه
        'K': 15,   # خریدار_نام
        'L': 12,   # خریدار_تلفن
        'M': 15,   # واسطه_نام
        'N': 12,   # واسطه_تلفن
        'O': 12,   # ذینفع
        'P': 12,   # وکالت_نامه
        'Q': 12,   # منطقه_پارکینگ
        'R': 12,   # شماره_پارکینگ
        'S': 12,   # تاریخ_پارک
        'T': 10    # زمان_پارک
    }
    
    for col, width in column_widths.items():
        worksheet.column_dimensions[col].width = width
    
    # اضافه کردن توضیحات در sheet دوم
    instructions_data = {
        'ستون': [
            'مالک', 'پلاک', 'شماره_بدنه', 'سیستم', 'نوع_خودرو', 'مدل', 'شماره_موتور', 
            'رنگ', 'ظرفیت', 'قیمت_پایه', 'خریدار_نام', 'خریدار_تلفن', 'واسطه_نام', 
            'واسطه_تلفن', 'ذینفع', 'وکالت_نامه', 'منطقه_پارکینگ', 'شماره_پارکینگ', 
            'تاریخ_پارک', 'زمان_پارک'
        ],
        'توضیحات': [
            'نام مالک خودرو (برگه سبز)',
            'شماره پلاک خودرو',
            'شماره VIN یا شماره بدنه (یکتا)',
            'سیستم خودرو',
            'نوع خودرو (پراید، پژو، ...)',
            'مدل خودرو',
            'شماره موتور',
            'رنگ خودرو',
            'تعداد سرنشین',
            'قیمت پایه به ریال (بدون جداکننده)',
            'نام خریدار',
            'شماره تلفن خریدار',
            'نام واسطه',
            'شماره تلفن واسطه',
            'نام ذینفع (اختیاری)',
            'شماره وکالت‌نامه (اختیاری)',
            'منطقه پارکینگ (A, B, C)',
            'شماره جای پارک',
            'تاریخ پارک (YYYY-MM-DD)',
            'زمان پارک (HH:MM)'
        ],
        'الزام': [
            'اجباری', 'اجباری', 'اجباری', 'اجباری', 'اجباری', 'اجباری', 'اجباری',
            'اجباری', 'اجباری', 'اجباری', 'اجباری', 'اجباری', 'اجباری', 'اجباری',
            'اختیاری', 'اختیاری', 'اجباری', 'اجباری', 'اجباری', 'اجباری'
        ]
    }
    
    instructions_df = pd.DataFrame(instructions_data)
    instructions_df.to_excel(writer, sheet_name='راهنما', index=False)

print("فایل اکسل کامل با نام 'complete_car_test_data.xlsx' ایجاد شد!")
print("این فایل شامل دو sheet است:")
print("1. خودروها: داده‌های تستی")
print("2. راهنما: توضیحات ستون‌ها")